﻿// Based on TortoiseSVN source code.

#include  "StdAfx.h"
#include  "DllMain.h"
#include  "Render.hpp"
#include  "Scope.hpp"
#include  "szVersion.hpp"
#include  <uxtheme.h>

typedef DWORD ARGB;

typedef HRESULT (WINAPI *FN_GetBufferedPaintBits) (HPAINTBUFFER hBufferedPaint, RGBQUAD **ppbBuffer, int *pcxRow);
typedef HPAINTBUFFER (WINAPI *FN_BeginBufferedPaint) (HDC hdcTarget, const RECT *prcTarget, BP_BUFFERFORMAT dwFormat, BP_PAINTPARAMS *pPaintParams, HDC *phdc);
typedef HRESULT (WINAPI *FN_EndBufferedPaint) (HPAINTBUFFER hBufferedPaint, BOOL fUpdateTarget);

HMODULE hUxTheme;

FN_GetBufferedPaintBits pfnGetBufferedPaintBits;
FN_BeginBufferedPaint pfnBeginBufferedPaint;
FN_EndBufferedPaint pfnEndBufferedPaint;

using namespace szpp;

bool HasAlpha(__in ARGB *pargb, SIZE &sizImage, int cxRow)
{
  ULONG cxDelta = cxRow - sizImage.cx;
  for (ULONG y = sizImage.cy; y; --y)
  {
    for (ULONG x = sizImage.cx; x; --x, ++pargb)
    {
      if (*pargb & 0xFF000000)
      {
        return true;
      }
    }

    pargb += cxDelta;
  }

  return false;
}

HRESULT Create32BitHBITMAP(HDC hdc, const SIZE *psize, __deref_opt_out void **ppvBits, __out HBITMAP* phBmp)
{
  *phBmp = NULL;

  BITMAPINFO bmi;
  ZeroMemory(&bmi, sizeof(bmi));
  bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  bmi.bmiHeader.biPlanes = 1;
  bmi.bmiHeader.biCompression = BI_RGB;

  bmi.bmiHeader.biWidth = psize->cx;
  bmi.bmiHeader.biHeight = psize->cy;
  bmi.bmiHeader.biBitCount = 32;

  HDC hdcUsed = hdc ? hdc : GetDC(NULL);
  if (hdcUsed)
  {
    *phBmp = CreateDIBSection(hdcUsed, &bmi, DIB_RGB_COLORS, ppvBits, NULL, 0);
    if (hdc != hdcUsed)
    {
      ReleaseDC(NULL, hdcUsed);
    }
  }
  return (NULL == *phBmp) ? E_OUTOFMEMORY : S_OK;
}

HRESULT ConvertToPARGB32(HDC hdc, __inout ARGB *pargb, HBITMAP hbmp, SIZE& sizImage, int cxRow)
{
  BITMAPINFO bmi;
  ZeroMemory(&bmi, sizeof(bmi));
  bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  bmi.bmiHeader.biPlanes = 1;
  bmi.bmiHeader.biCompression = BI_RGB;

  bmi.bmiHeader.biWidth = sizImage.cx;
  bmi.bmiHeader.biHeight = sizImage.cy;
  bmi.bmiHeader.biBitCount = 32;

  HRESULT hr = E_OUTOFMEMORY;
  HANDLE hHeap = GetProcessHeap();
  void *pvBits = HeapAlloc(hHeap, 0, bmi.bmiHeader.biWidth * 4 * bmi.bmiHeader.biHeight);
  if (pvBits)
  {
    hr = E_UNEXPECTED;
    if (GetDIBits(hdc, hbmp, 0, bmi.bmiHeader.biHeight, pvBits, &bmi, DIB_RGB_COLORS) == bmi.bmiHeader.biHeight)
    {
      ULONG cxDelta = cxRow - bmi.bmiHeader.biWidth;
      ARGB *pargbMask = static_cast<ARGB *>(pvBits);

      for (ULONG y = bmi.bmiHeader.biHeight; y; --y)
      {
        for (ULONG x = bmi.bmiHeader.biWidth; x; --x)
        {
          if (*pargbMask++)
          {
            // transparent pixel
            *pargb++ = 0;
          }
          else
          {
            // opaque pixel
            *pargb++ |= 0xFF000000;
          }
        }

        pargb += cxDelta;
      }

      hr = S_OK;
    }

    HeapFree(hHeap, 0, pvBits);
  }

  return hr;
}

HRESULT ConvertBufferToPARGB32(HPAINTBUFFER hPaintBuffer, HDC hdc, HICON hicon, SIZE& sizIcon)
{
  RGBQUAD *prgbQuad;
  int cxRow;
  HRESULT hr = pfnGetBufferedPaintBits(hPaintBuffer, &prgbQuad, &cxRow);
  if (SUCCEEDED(hr))
  {
    ARGB *pargb = reinterpret_cast<ARGB *>(prgbQuad);
    if (!HasAlpha(pargb, sizIcon, cxRow))
    {
      ICONINFO info;
      if (GetIconInfo(hicon, &info))
      {
        if (info.hbmMask)
        {
          hr = ConvertToPARGB32(hdc, pargb, info.hbmMask, sizIcon, cxRow);
        }

        DeleteObject(info.hbmColor);
        DeleteObject(info.hbmMask);
      }
    }
  }

  return hr;
}

SZ_NS_BEG(Render)

void InitializeRender(HMODULE hModule)
{
  if (wVersion >= OS_VERSION_VISTA && hUxTheme == 0)
  {
    hUxTheme = LoadLibrary(SZL("UXTHEME.DLL"));

    if (hUxTheme)
    {
      pfnGetBufferedPaintBits = (FN_GetBufferedPaintBits)GetProcAddress(hUxTheme, "GetBufferedPaintBits");
      pfnBeginBufferedPaint = (FN_BeginBufferedPaint)GetProcAddress(hUxTheme, "BeginBufferedPaint");
      pfnEndBufferedPaint = (FN_EndBufferedPaint)GetProcAddress(hUxTheme, "EndBufferedPaint");
    }
  }
}

void UninitializeRender()
{
  if (hUxTheme)
    FreeLibrary(hUxTheme);
}

HBITMAP IconToBitmapPARGB32(UINT uIcon)
{
  HICON hIcon = (HICON)LoadImage(hDllInstance, MAKEINTRESOURCE(uIcon), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);
  if (!hIcon)
    return NULL;

  if (pfnBeginBufferedPaint == NULL || pfnEndBufferedPaint == NULL || pfnGetBufferedPaintBits == NULL)
    return NULL;

  SIZE sizIcon;
  sizIcon.cx = GetSystemMetrics(SM_CXSMICON);
  sizIcon.cy = GetSystemMetrics(SM_CYSMICON);

  RECT rcIcon;
  SetRect(&rcIcon, 0, 0, sizIcon.cx, sizIcon.cy);
  HBITMAP hBmp = NULL;

  HDC hdcDest = CreateCompatibleDC(NULL);
  if (hdcDest)
  {
    if (SUCCEEDED(Create32BitHBITMAP(hdcDest, &sizIcon, NULL, &hBmp)))
    {
      HBITMAP hbmpOld = (HBITMAP)SelectObject(hdcDest, hBmp);
      if (hbmpOld)
      {
        BLENDFUNCTION bfAlpha = { AC_SRC_OVER, 0, 255, AC_SRC_ALPHA };
        BP_PAINTPARAMS paintParams = {0};
        paintParams.cbSize = sizeof(paintParams);
        paintParams.dwFlags = BPPF_ERASE;
        paintParams.pBlendFunction = &bfAlpha;

        HDC hdcBuffer;
        HPAINTBUFFER hPaintBuffer = pfnBeginBufferedPaint(hdcDest, &rcIcon, BPBF_DIB, &paintParams, &hdcBuffer);
        if (hPaintBuffer)
        {
          if (DrawIconEx(hdcBuffer, 0, 0, hIcon, sizIcon.cx, sizIcon.cy, 0, NULL, DI_NORMAL))
          {
            // If icon did not have an alpha channel we need to convert buffer to PARGB
            ConvertBufferToPARGB32(hPaintBuffer, hdcDest, hIcon, sizIcon);
          }

          // This will write the buffer contents to the destination bitmap
          pfnEndBufferedPaint(hPaintBuffer, TRUE);
        }

        SelectObject(hdcDest, hbmpOld);
      }
    }

    DeleteDC(hdcDest);
  }

  DestroyIcon(hIcon);

  return hBmp;
}

HBITMAP IconToBitmap(UINT uIcon)
{
  IconScope hIcon((HICON)LoadImage(hDllInstance, MAKEINTRESOURCE(uIcon), IMAGE_ICON, 12, 12, LR_DEFAULTCOLOR));
  if (!hIcon)
    return NULL;

  RECT rect;

  rect.right = ::GetSystemMetrics(SM_CXMENUCHECK);
  rect.bottom = ::GetSystemMetrics(SM_CYMENUCHECK);

  rect.left = rect.top = 0;

  HWND desktop = ::GetDesktopWindow();
  if (desktop == NULL)
    return NULL;

  DcHolder screen_dev(desktop, ::GetDC(desktop));
  if (screen_dev == NULL)
    return NULL;

  // Create a compatible DC
  DcOwner dst_hdc(::CreateCompatibleDC(screen_dev));
  if (dst_hdc == NULL)
    return NULL;

  // Create a new bitmap of icon size
  BitmapScope bmp(::CreateCompatibleBitmap(screen_dev, rect.right, rect.bottom));
  if (bmp == NULL)
    return NULL;

  // Select it into the compatible DC
  HBITMAP old_dst_bmp = (HBITMAP)::SelectObject(dst_hdc, bmp);
  if (old_dst_bmp == NULL)
    return NULL;

  // Fill the background of the compatible DC with the white color
  // that is taken by menu routines as transparent
  ::SetBkColor(dst_hdc, RGB(255, 255, 255));
  ::ExtTextOut(dst_hdc, 0, 0, ETO_OPAQUE, &rect, NULL, 0, NULL);

  // Draw the icon into the compatible DC
  ::DrawIconEx(dst_hdc, 0, 0, hIcon, rect.right, rect.bottom, 0, NULL, DI_NORMAL);

  // Restore settings
  ::SelectObject(dst_hdc, old_dst_bmp);

  return bmp;
}

SZ_NS_END(Render)
